# ColoredHealth release 3 by David Bowland
# ./addons/eventscripts/coloredhealth/coloredhealth.py

# >>> To configure this addon please see coloredhealth.cfg <<<

"""
Sets the color and transparency of players based on health. Requires only ES 2.0+
"""


import es
import os.path


info = es.AddonInfo()
info.name = 'ColoredHealth'
info.version = '3'
info.url = 'http://addons.eventscripts.com/addons/view/coloredhealth'
info.basename = 'coloredhealth'
info.author = 'SuperDave'


tuple_arg_names = ('team2red', 'team2green', 'team2blue', 'team2alpha', 'team3red', 'team3green', 'team3blue', 'team3alpha')
dict_levels = {}


def load():
   """
   Checks to make sure critical server variables are created by the config
   Finds the top level
   Calls round_start
   """
   global int_top_level

   if not es.exists('command', 'coloredhealth_level_add'):
      es.regcmd('coloredhealth_level_add', 'coloredhealth/level_cmd', 'coloredhealth_level_add <health> <t red> <t green> <t blue> <t alpha> <ct red> <ct green> <ct blue> <ct alpha>\nServer command for adding color levels for player health')
   if not es.exists('command', 'coloredhealth_level_remove'):
      es.regcmd('coloredhealth_level_remove', 'coloredhealth/level_cmd', 'coloredhealth_level_remove <health>\nServer command for removing color levels for player health')

   if os.path.isfile(es.getAddonPath('coloredhealth') + '/coloredhealth.cfg'):
      es.server.cmd('es_xmexec ../addons/eventscripts/coloredhealth/coloredhealth.cfg')
   else:
      es.dbgmsg(0, 'ColoredHealth: Unable to load coloredhealth.cfg! Please ensure it is in the ./coloredhealth/ directory.')

   round_start({})


def round_start(event_var):
   """Ensures all players are the correct color and in rendermode 1"""
   dict_player_list = es.createplayerlist()
   for int_player in dict_player_list:
      player_spawn({'userid':str(int_player), 'es_userteam':dict_player_list[int_player]['teamid']})


def player_spawn(event_var):
   """Ensures the player is in rendermode 1 and calls set_color"""
   if int(event_var['es_userteam']) > 1:
      es.server.cmd('es_xfire %s !self addoutput \"rendermode 1\"' % event_var['userid'])
      set_color(event_var['userid'])


def player_health(event_var):
   """Updates player color when a player changes health if ExtendedEvents is loaded"""
   set_color(event_var['userid'])


def player_hurt(event_var):
   """Updates player color for the hurt player"""
   set_color(event_var['userid'])


def unload():
   """Resets player color"""
   dict_player_list = es.createplayerlist()
   for str_player in dict_player_list:
      if int(dict_player_list[str_player]['teamid']) > 1:
         es.server.cmd('es_xfire %s !self color \"255 255 255\"' % str_player)
         es.server.cmd('es_xfire %s !self alpha 255' % str_player)


def set_color(str_player):
   """
   Determines the health level of str_player
   Determines the player's color level and blends the color with the next level if the player is between levels
   Sets the player's color
   """
   if dict_levels:
      dict_colors = {'red':0, 'green':0, 'blue':0, 'alpha':0}
      int_health = int(es.getplayerprop(str_player, 'CBasePlayer.m_iHealth'))
      int_team = es.getplayerteam(str_player)
      int_health_below = int_health_above = -1

      if dict_levels.has_key(int_health):
         int_health_below = int_health

      else:
         for int_temp_health in dict_levels:
            if int_health < int_temp_health and (int_temp_health < int_health_above or int_health_above == -1):
               int_health_above = int_temp_health
            elif int_health > int_temp_health and int_temp_health > int_health_below:
               int_health_below = int_temp_health

      if int_health_below == -1 or int_health_above == -1:
         if int_health_below == -1:
            dict_current_level = dict_levels[int_health_above]
         else:
            dict_current_level = dict_levels[int_health_below]

         for str_color in ('red', 'green', 'blue', 'alpha'):
            dict_colors[str_color] = dict_current_level['team%s%s' % (int_team, str_color)]

      else:
         int_health_difference = int_health_above - int_health_below
         dict_above_level = dict_levels[int_health_above]
         dict_below_level = dict_levels[int_health_below]
         int_health -= int_health_below

         for str_color in ('red', 'green', 'blue', 'alpha'):
            str_team_color = 'team%s%s' % (int_team, str_color)
            dict_colors[str_color] = dict_below_level[str_team_color] + int(((dict_above_level[str_team_color] - dict_below_level[str_team_color]) * int_health) / int_health_difference)

      es.server.cmd('es_xfire %s !self color \"%s %s %s\"' % (str_player, dict_colors['red'], dict_colors['green'], dict_colors['blue']))
      es.server.cmd('es_xfire %s !self alpha %s' % (str_player, dict_colors['alpha']))


def level_cmd():
   """
   coloredhealth_level_add <health> <t red> <t green> <t blue> <t alpha> <ct red> <ct green> <ct blue> <ct alpha>
   coloredhealth_level_remove <health>
   Adds or removes the supplied color level from dict_levels
   """
   global dict_levels

   int_arg_count = es.getargc()
   str_command = es.getargv(0).lower()
   if int_arg_count == {'coloredhealth_level_add':10, 'coloredhealth_level_remove':2}[str_command]:
      int_health = int(es.getargv(1))
      if str_command == 'coloredhealth_level_add':
         if int_health >= 0:

            dict_levels[int_health] = {}
            for int_count in range(2, int_arg_count):
               dict_levels[int_health][tuple_arg_names[int_count - 2]] = int(es.getargv(int_count))

         else:
            es.dbgmsg(0, 'ColoredHealth: coloredhealth_level_add health value cannot be less than zero.')
      else:
         if dict_levels.has_key(int_health):
            del dict_levels[int_health]
   else:
      es.dbgmsg(0, 'Syntax: ' + {'coloredhealth_level_add':'coloredhealth_level_add <health> <t red> <t green> <t blue> <t alpha> <ct red> <ct green> <ct blue> <ct alpha>', 'coloredhealth_level_remove':'coloredhealth_level_remove <health>'}[str_command])