"""
 *****************************************************
 * ServSecurity 0.5                                  *
 * By Dark Session                                   *
 * ***************************************************
 * This work is licensed under the Creative Commons  *
 * Attribution-Noncommercial-Share Alike 3.0         *
 * Unported License. To view a copy of this license, *
 * visit                                             *
 * http://creativecommons.org/licenses/by-nc-sa/3.0/ *
 * or send a letter to Creative Commons, 171 Second  *
 * Street, Suite 300, San Francisco, California,     *
 * 94105, USA.                                       *
 *****************************************************
"""



import es
import os
import time
import random
import socket
import urllib
import datetime
import threading
import gamethread

info = es.AddonInfo()
info.name      = 'ServSecurity'
info.version   = '0.5'
info.basename  = 'servsecurity'
info.author    = 'Dark Session'
info.url       = 'http://addons.eventscripts.com/addons/view/servsecurity'

es.ServerVar('servsecurity_version', info.version, 'Powerful script by Dark Session to prevent server lags, hacking attemps, abuse and crashes').makepublic()

# CommandList FLAGS:
# bl: Block
# rm: Remove command (overwrite)
# ---
# Side:
# client
# server

"""
    LogLevels:
        0 = Disabled
        1 = Important
        2 = Warnings
        3 = Informations

"""

# Don't steal this list or future releases of ServSecurity will be encrypted!
CommandList = {
    "_restart": {
        'flags': ['rm'],
        'side': ['server']
        },
    "ai_set_move_height_epsilon": {
        'flags': ['bl'],
        'side': ['server']
        },
    "ai_clear_bad_links": {
        'flags': ['bl'],
        'side': ['server']
        },
    "ai_debug_node_connect": {
        'flags': ['bl'],
        'side': ['server']
        },
    "ai_dump_hints": {
        'flags': ['bl'],
        'side': ['server']
        },
    "ai_set_move_height_epsilon": {
        'flags': ['bl'],
        'side': ['server']
        },
    "ai_show_node": {
        'flags': ['bl'],
        'side': ['server']
        },
    "ainet_generate_report": {
        'flags': ['bl'],
        'side': ['server','client']
        },
    "ainet_generate_report_only": {
        'flags': ['rm'],
        'side': ['server','client']
        },
    "alias": {
        'flags': ['bl'],
        'side': ['server']
        },
    "bench_end": {
        'flags': ['rm'],
        'side': ['server']
        },
    "bench_start": {
        'flags': ['rm'],
        'side': ['server']
        },
    "bench_upload": {
        'flags': ['rm'],
        'side': ['server']
        },
    "BindToggle": {
        'flags': ['bl'],
        'side': ['server']
        },
    "bench_upload": {
        'flags': ['bl'],
        'side': ['server']
        },
    "bench_upload": {
        'flags': ['bl'],
        'side': ['server']
        },
    "cache_print": {
        'flags': ['bl'],
        'side': ['server']
        },
    "cache_print_lru": {
        'flags': ['bl'],
        'side': ['server']
        },
    "cache_print_summary": {
        'flags': ['bl'],
        'side': ['server']
        },
    "cast_hull": {
        'flags': ['rm'],
        'side': ['server']
        },
    "cast_ray": {
        'flags': ['rm'],
        'side': ['server']
        },
    "cc_lookup_crc": {
        'flags': ['bl'],
        'side': ['server']
        },
    "cmd": {
        'flags': ['rm'],
        'side': ['server','client']
        },
    "collision_test": {
        'flags': ['rm'],
        'side': ['server']
        },
    "CreatePredictionError": {
        'flags': ['rm'],
        'side': ['server']
        },
    "dbghist_addline": {
        'flags': ['rm'],
        'side': ['server']
        },
    "dbghist_dump": {
        'flags': ['rm'],
        'side': ['server']
        },
    "dti_flush": {
        'flags': ['bl'],
        'side': ['server']
        },
    "dump_entity_sizes": {
        'flags': ['rm'],
        'side': ['server']
        },
    "dump_globals": {
        'flags': ['rm'],
        'side': ['server']
        },
    "dump_terrain": {
        'flags': ['rm'],
        'side': ['server']
        },
    "dumpcountedstrings": {
        'flags': ['rm','bl'],
        'side': ['server']
        },
    "dumpentityfactories": {
        'flags': ['rm'],
        'side': ['server']
        },
    "dumpeventqueue": {
        'flags': ['rm'],
        'side': ['server']
        },
    "dumpgamestringtable": {
        'flags': ['rm'],
        'side': ['server']
        },
    "dumpstringtables": {
        'flags': ['rm'],
        'side': ['server']
        },
    "ent_debugkeys": {
        'flags': ['bl'],
        'side': ['server']
        },
    "ent_dump": {
        'flags': ['rm'],
        'side': ['server']
        },
    "es_flags": {
        'flags': ['bl'],
        'side': ['server']
        },
    "es_xflags": {
        'flags': ['bl'],
        'side': ['server']
        },
    "est_closefile": {
        'flags': ['bl'],
        'side': ['server']
    },
    "est_deleteline": {
        'flags': ['bl'],
        'side': ['server']
    },
    "est_openfile": {
        'flags': ['bl'],
        'side': ['server']
    },
    "exit": {
        'flags': ['bl'],
        'side': ['server']
        },
    "flush": {
        'flags': ['rm'],
        'side': ['server']
        },
    "flush_locked": {
        'flags': ['rm'],
        'side': ['server']
        },
    "groundlist": {
        'flags': ['rm'],
        'side': ['server']
        },
    "host_runofftime": {
        'flags': ['bl'],
        'side': ['server']
        },
    "kdtree_test": {
        'flags': ['rm'],
        'side': ['server']
        },
    "killserver": {
        'flags': ['rm'],
        'side': ['server']
        },
    "listmaps": {
        'flags': ['rm','bl'],
        'side': ['server']
        },
    "listmodels": {
        'flags': ['rm'],
        'side': ['server']
        },
    "listRecentNPCSpeech": {
        'flags': ['rm'],
        'side': ['server']
        },
    "ListServerUserMessages": {
        'flags': ['bl'],
        'side': ['server']
        },
    "nextmap": {
        'flags': ['rm','bl'],
        'side': ['server','client']
        },
    "ma_favourites": {
        'flags': ['rm','bl'],
        'side': ['server','client']
        },
    "ma_map": {
        'flags': ['rm','bl'],
        'side': ['server','client']
        },
    "ma_nextmap": {
        'flags': ['rm','bl'],
        'side': ['server','client']
        },
    "ma_showrestrict": {
        'flags': ['rm','bl'],
        'side': ['server','client']
        },
    "ma_showsounds": {
        'flags': ['rm','bl'],
        'side': ['server','client']
        },
    "ma_timeleft": {
        'flags': ['rm','bl'],
        'side': ['server','client']
        },
    "ma_version": {
        'flags': ['rm','bl'],
        'side': ['server','client']
        },
    "mat_configcurrent": {
        'flags': ['bl'],
        'side': ['server']
        },
    "mat_reloadallmaterials": {
        'flags': ['rm'],
        'side': ['server']
        },
    "mem_compact": {
        'flags': ['bl'],
        'side': ['server']
        },
    "mem_dump": {
        'flags': ['rm'],
        'side': ['server']
        },
    "mem_eat": {
        'flags': ['bl'],
        'side': ['server']
        },
    "mem_vcollide": {
        'flags': ['bl'],
        'side': ['server']
        },
    "memory": {
        'flags': ['rm'],
        'side': ['server']
        },
    "mp_dump_timers": {
        'flags': ['rm'],
        'side': ['server']
        },
    # DEVCOMMENT Todo for version 0.5: Check nav_,net_ Commands /DEVCOMMENT
    "notarget": {
        'flags': ['bl'],
        'side': ['server']
        },
    "npc_ammo_deplete": {
        'flags': ['rm','bl'],
        'side': ['server']
        },
    "npc_freeze": {
        'flags': ['rm','bl'],
        'side': ['server']
        },
    "npc_go": {
        'flags': ['rm'],
        'side': ['server']
        },
    "npc_heal": {
        'flags': ['rm','bl'],
        'side': ['server']
        },
    "npc_speakall": {
        'flags': ['rm'],
        'side': ['server']
        },
    "npc_teleport": {
        'flags': ['rm','bl'],
        'side': ['server']
        },
    "npc_thinknow": {
        'flags': ['rm','bl'],
        'side': ['server']
        },
    "npc_vphysics": {
        'flags': ['bl'],
        'side': ['server']
        },
    "phys_swap": {
        'flags': ['bl'],
        'side': ['server']
        },
    "physics_budget": {
        'flags': ['bl'],
        'side': ['server']
        },
    "physics_debug_entity": {
        'flags': ['rm'],
        'side': ['server']
        },
    "physics_highlight_active": {
        'flags': ['bl'],
        'side': ['server']
        },
    "physics_report_active": {
        'flags': ['bl'],
        'side': ['server']
        },
    "physics_select": {
        'flags': ['rm'],
        'side': ['server']
        },
    "profile": {
        'flags': ['bl'],
        'side': ['server']
        },
    "profilecmd": {
        'flags': ['bl'],
        'side': ['server']
        },
    "prop_debug": {
        'flags': ['rm'],
        'side': ['server']
        },
    "queue": {
        'flags': ['bl'],
        'side': ['server']
        },
    "quit": {
        'flags': ['bl'],
        'side': ['server']
        },
    "quti":{
        'flags': ['bl'],
        'side': ['server']
        },
    "r_flushlod": {
        'flags': ['bl'],
        'side': ['server']
        },
    "r_mmx": {
        'flags': ['bl'],
        'side': ['server']
        },
    "r_printdecalinfo": {
        'flags': ['bl'],
        'side': ['server']
        },
    "r_sse": {
        'flags': ['bl'],
        'side': ['server']
        },
    "r_sse2": {
        'flags': ['bl'],
        'side': ['server']
        },
    "report_entities": {
        'flags': ['rm'],
        'side': ['server']
        },
    "report_simthinklist": {
        'flags': ['bl'],
        'side': ['server']
        },
    "report_soundpatch": {
        'flags': ['bl'],
        'side': ['server']
        },
    "report_touchlinks": {
        'flags': ['bl'],
        'side': ['server']
        },
    "respawn_entities": {
        'flags': ['rm'],
        'side': ['server']
        },
    "restart": {
        'flags': ['bl'],
        'side': ['server']
        },
    "rr_reloadresponsesystems": {
        'flags': ['rm'],
        'side': ['server']
        },
    "scene_flush": {
        'flags': ['rm'],
        'side': ['server']
        },
    "scene_mem": {
        'flags': ['bl'],
        'side': ['server']
        },
    "snd_restart": {
        'flags': ['bl'],
        'side': ['server']
        },
    "soundscape_flush": {
        'flags': ['bl'],
        'side': ['server']
        },
    "surfaceprop": {
        'flags': ['rm'],
        'side': ['server']
        },
    "sv_findsoundname": {
        'flags': ['bl'],
        'side': ['server']
        },
    "sv_precacheinfo": {
        'flags': ['bl'],
        'side': ['server']
        },
    "sv_soundemitter_filecheck": {
        'flags': ['bl'],
        'side': ['server']
        },
    "sv_soundemitter_flush": {
        'flags': ['bl'],
        'side': ['server']
        },
    "sv_soundscape_printdebuginfo": {
        'flags': ['bl'],
        'side': ['server']
        },
    "Test_CreateEntity": {
        'flags': ['rm'],
        'side': ['server']
        },
    "test_dispatcheffect": {
        'flags': ['rm'],
        'side': ['server']
        },
    "Test_EHandle": {
        'flags': ['rm'],
        'side': ['server']
        },
    "test_entity_blocker": {
        'flags': ['rm'],
        'side': ['server']
        },
    "Test_InitRandomEntitySpawner": {
        'flags': ['rm'],
        'side': ['server']
        },
    "Test_ProxyToggle_EnableProxy": {
        'flags': ['rm'],
        'side': ['server']
        },
    "Test_ProxyToggle_SetValue": {
        'flags': ['rm'],
        'side': ['server']
        },
    "Test_RandomizeInPVS": {
        'flags': ['rm'],
        'side': ['server']
        },
    "Test_RandomPlayerPosition": {
        'flags': ['rm'],
        'side': ['server']
        },
    "Test_RemoveAllRandomEntities": {
        'flags': ['rm'],
        'side': ['server']
        },
    "Test_SpawnRandomEntities": {
        'flags': ['rm'],
        'side': ['server']
        },
    "testlib": {
        'flags': ['bl'],
        'side': ['server']
        },
    "testprint": {
        'flags': ['bl'],
        'side': ['server']
        },
    "testtest": {
        'flags': ['bl'],
        'side': ['server']
        },
    "testsuite": {
        'flags': ['bl'],
        'side': ['server']
        },
    "timeleft": {
        'flags': ['rm', 'bl'],
        'side': ['server','client']
        },
    "vox_reload": {
        'flags': ['rm', 'bl'],
        'side': ['server']
        },
    "voxeltree_playerview": {
        'flags': ['rm'],
        'side': ['server']
        },
    "vprof": {
        'flags': ['bl'],
        'side': ['server']
        },
    "vprof_cachemiss": {
        'flags': ['bl'],
        'side': ['server']
        },
    "vprof_cachemiss_off": {
        'flags': ['bl'],
        'side': ['server']
        },
    "vprof_cachemiss_on": {
        'flags': ['bl'],
        'side': ['server']
        },
    "vprof_dump_groupnames": {
        'flags': ['bl'],
        'side': ['server']
        },
    "vprof_generate_report": {
        'flags': ['bl'],
        'side': ['server']
        },
    "vprof_generate_report_AI": {
        'flags': ['bl'],
        'side': ['server']
        },
    "vprof_generate_report_AI_only": {
        'flags': ['bl'],
        'side': ['server']
        },
    "vprof_generate_report_hierarchy": {
        'flags': ['bl'],
        'side': ['server']
        },
    "vprof_generate_report_map_load": {
        'flags': ['bl'],
        'side': ['server']
        },
    "vprof_off": {
        'flags': ['bl'],
        'side': ['server']
        },
    "vprof_on": {
        'flags': ['bl'],
        'side': ['server']
        },
    "vprof_playback_average": {
        'flags': ['bl'],
        'side': ['server']
        },
    "vprof_playback_start": {
        'flags': ['bl'],
        'side': ['server']
        },
    "vprof_playback_step": {
        'flags': ['bl'],
        'side': ['server']
        },
    "vprof_playback_stepback": {
        'flags': ['bl'],
        'side': ['server']
        },
    "vprof_playback_stop": {
        'flags': ['bl'],
        'side': ['server']
        },
    "vprof_record_start": {
        'flags': ['bl'],
        'side': ['server']
        },
    "vprof_record_stop": {
        'flags': ['bl'],
        'side': ['server']
        },
    "vprof_reset": {
        'flags': ['bl'],
        'side': ['server']
        },
    "vprof_reset_peaks": {
        'flags': ['bl'],
        'side': ['server']
        },
    "vprof_vtune_group": {
        'flags': ['bl'],
        'side': ['server']
        },
    "wait": {
        'flags': ['bl'],
        'side': ['server']
        },
    "wc_update_entity": {
        'flags': ['rm','bl'],
        'side': ['server']
        },
    "wc_update_safe_entities": {
        'flags': ['rm'],
        'side': ['server']
        },
    "xalias": {
        'flags': ['bl'],
        'side': ['server']
        }
    }

ForbiddenUsernames = [
    "",
    "0",
    "unnamed",
    "unconnected",
    "empty"
    ]

ConnectingBlockNotBanCMDs = ['menuseleect']

ProtectServerVars = {
        'eventscripts_protectrcon': {'default': '1', 'cheatflag': 1, 'unload_remove_cheatflag': 1},
        'rcon_password': {'default': '_request_', 'requestfile': '_cfgfile_', 'hidevalue': 1, 'load_removecheatflag': 1, 'protected': 1},
        'sv_cheats': {'default': '0', 'cheatflag': 1},
        'sv_rcon_log': {'default': '1', 'cheatflag': 1},
        'sv_allow_wait_command': {'default': '0', 'loglevel': 3}
    }

Plugins = {
        'mani_admin_build_date': {'pluginname': 'Mani Admin Plugin', 'homepage': 'http://mani-admin-plugin.com/'},
        'mani_admin_plugin_version': {'pluginname': 'Mani Admin Plugin', 'homepage': 'http://mani-admin-plugin.com/'},
        'es_corelib_ver': {'pluginname': 'Eventscripts Corelib', 'homepage': 'http://mattie.net/cs/'},
        'metamod_version': {'pluginname': 'Metamod', 'homepage': 'http://www.sourcemm.net/',},
        'sourcemod_version': {'pluginname': 'Sourcemod', 'homepage': 'http://www.sourcemod.net/'},
        'est_version': {'pluginname': 'Eventscripts Tools (EST)', 'homepage': 'http://forums.eventscripts.com/viewforum.php?f=42'},
        # Your script/plugin here? Send me an email to darksession@the-holy-crew.ch
    }

UpdateCheckURL = "http://www.swiss-esport.ch/servsecurity/updatecheck.php"
PluginVerUL = "http://www.swiss-esport.ch/servsecurity/plugins.php"
ScriptVersion = info.version
# ASCII chars number 0 - 31
ForbiddenChars = map(lambda x: chr(x), range(0,32))
ConnectWhitelist = ["BOT", "STEAM_ID_LAN"]
IPWhitelist = ['127.0.0.1', 'localhost', 'none']
ConnectionAttemps = {}
MaxUsernameLength = 32
Loaded = False
PreLoad = False
IllegalCharCount = {}
Kicked = []
Config = {
        'block_connection_spam': 1,
        'block_colored_names': 1,
        'maxconnectionsperip': 5,
        'ipbantime': (3600*24),
        'steamidbantime': (3600*24),
        'protectvars': 1,
        'commandblocker': 1,
        'steamid_pending_kick': 1,
        'steamid_pending_kick_time': 5,
        'block_text_with_illegal_chars': 1,
        'illegal_chars_max_tries': 5,
        'crashreporter': 1,
        'timeformat': 2, # 1 = MM/DD/YYYY | 2 = DD.MM.YYYY | 3 = YYYY-MM-DD
        'kick_unassigned': 1,
        'loglevel': 3,
        'logtype': 3, # 0 = Disabled, 1 = Server-Log, 2 = ServSecurity Log, 3 = Server + ServSecurity Log
        'one_logfile': 0,
        'messsage_on_connect': 1,
        'replace_copy_command': 1,
        'file_with_server_variables': 'server.cfg'
    }
Wrap = os.linesep
LogfilePointer = None
_AllowUnload = False
UserIDToIP = {}
_Password = ""

def load():
    global Loaded, PreLoad
    if Loaded:
        return

    PreLoad = True

    for variable in Config:
        es.ServerVar("servsecurity_" + variable, Config[variable], 'ServSecurity config variable')

    es.regcmd('servsecurity_updatecheck', 'servsecurity/Check4Updates', 'ServSecurity: Check for new ServSecurity version')
    es.regcmd('servsecurity_unload', 'servsecurity/UnloadMe', 'ServSecurity: Unload ServSecurity (password required) - Usage: servsecurity_unload <ServSecurity Password>')
    es.regcmd('servsecurity_setpassword', 'servsecurity/SetPassword', 'ServSecurity: Set ServSecurity password - Usage: servsecurity_setpassword <Password>')
    es.regcmd('servsecurity_checkplugins', 'servsecurity/CheckPlugins', 'ServSecurity: Are your server plugins up-to-date?')

    es.server.cmd("exec servsecurity")

    for variable in Config:
        Config[variable] = str(es.ServerVar("servsecurity_" + variable))

    OpenLogfile()

    if CFGVar('replace_copy_command'):
        es.regcmd("es_xcopy", "servsecurity/XCopy", "Protected with ServSecurity")
        es.regcmd("es_copy", "servsecurity/Copy", "Protected with ServSecurity")

    if CFGVar('commandblocker') == 1:
        for Command in CommandList:
            Flags = CommandList[Command]['flags']
            Side = CommandList[Command]['side']
            if 'rm' in Flags:
                if 'server' in Side:
                    es.regcmd(Command, 'servsecurity/bannedservercmd')
                if 'client' in Side:
                    es.regclientcmd(Command, 'servsecurity/bannedservercmd')
            if 'bl' in Flags:
                es.flags('add', 'cheat', Command)

    if CFGVar('protectvars') == 1:
        ServerVariables = dict(ProtectServerVars)
        for ServerVar in ServerVariables:
            if ProtectServerVars[ServerVar]['default'] == '_request_':
                if not ProtectServerVars[ServerVar].has_key('requestfile'):
                    del ProtectServerVars[ServerVar]['requestfile']
                    Log(1, "Cant protect var '" + ServerVar + "': Request file not defined")
                    continue

                File = ProtectServerVars[ServerVar]['requestfile']
                if File == "_cfgfile_":
                    File = Config['file_with_server_variables']

                if (ProtectServerVars[ServerVar].has_key('load_removecheatflag') and ProtectServerVars[ServerVar]['load_removecheatflag']) or (ProtectServerVars[ServerVar].has_key('cheatflag') and ProtectServerVars[ServerVar]['cheatflag']):
                    es.flags('remove', 'cheat', ServerVar)

                if os.path.exists(es.ServerVar('eventscripts_gamedir') + "/cfg/" + File) or os.path.exists(es.ServerVar('eventscripts_gamedir') + "/cfg/" + File + ".cfg"):
                    es.server.cmd("exec " + File)
                else:
                    del ProtectServerVars[ServerVar]
                    Log(1,  "Unable to exec file '" + File + "' to protect var '" + ServerVar + "'")
                    continue

            if not es.exists('variable', ServerVar):
                Log(1,  "Cant protect var '" + ServerVar + "': Variable not found")
                del ProtectServerVars[ServerVar]
                continue
            elif str(es.ServerVar(ServerVar)) == "":
                Log(1,  "Cant protect var '" + ServerVar + "': Variable empty")
                del ProtectServerVars[ServerVar]
                continue
            elif str(es.ServerVar(ServerVar)) == "_request_":
                Log(1,  "Cant protect var '" + ServerVar + "': Request variable failed!")
                del ProtectServerVars[ServerVar]
                continue

            if ProtectServerVars[ServerVar]['default'] == '_request_':
                ProtectServerVars[ServerVar]['default'] = str(es.ServerVar(ServerVar))

            if es.ServerVar(ServerVar) != ProtectServerVars[ServerVar]['default']:
                es.set(ServerVar, ProtectServerVars[ServerVar]['default'])
                es.forcevalue(ServerVar, ProtectServerVars[ServerVar]['default'])

            if ProtectServerVars[ServerVar].has_key('cheatflag') and ProtectServerVars[ServerVar]['cheatflag']:
                es.flags('add', 'cheat', ServerVar)

            es.flags('add', 'notify', ServerVar)

            if ProtectServerVars[ServerVar].has_key('protected') and ProtectServerVars[ServerVar]['protected']:
                es.flags('add', 'protected', ServerVar)

            Log(3, "Variable '" + ServerVar + "' protected")

    gamethread.delayedname(2, 'servsecurity_varmonitor', VariableMonitoring)


    es.addons.registerSayFilter(sayFilter)
    es.addons.registerClientCommandFilter(cmdFilter)

    DisableRCONCrashExploit()

    if CFGVar('crashreporter'):
        reportfile = es.getAddonPath('servsecurity') + "/crashreport.txt"
        if not os.path.isfile(reportfile):
            fp = open(reportfile, 'w')
            fp.write("")
            fp.close()

        tmpfile = es.getAddonPath('servsecurity') + "/data/tmpcrashreport.txt"

        if os.path.isfile(tmpfile):
            fp = open(tmpfile, 'r')
            crashtime = fp.read()
            fp.close()
            if crashtime and float(crashtime) > 0:
                CrashDate = Timestamp2Date(crashtime)
                RestartDate = Timestamp2Date(time.time())

                LogText = "Server crash detected! Server crashed at " + str(CrashDate) + ". Restarted at " + str(RestartDate)
                try:
                    fp = open(reportfile, 'a')
                    fp.writelines(LogText + Wrap)
                    fp.close()
                except:
                    Log(1, LogText)

        fp = open(tmpfile, 'w')
        fp.write(str(time.time()))
        fp.close()

        gamethread.delayedname(2, 'servsecurity_crashreporter', WriteCrashReportFile)

    gamethread.delayedname(4, 'servsecurity_writelogfile', LogFileWrite)
    if CFGVar('block_connection_spam'):
        gamethread.delayedname(30, 'servsecurity_resetconnectionattempsvar', ResetConnectionAttempsVar)

    Loaded = True
    PreLoad = False

    Check4Updates()
    CheckPlugins()


def unload():
    global Loaded, _AllowUnload

    if _Password == "":
        _AllowUnload = True

    if CFGVar('commandblocker') == 1:
        for Command in CommandList:
            Flags = CommandList[Command]['flags']
            Side = CommandList[Command]['side']
            if 'rm' in Flags:
                if 'client' in Side:
                    es.unregclientcmd(Command)
                    Log(3, "Unregistered clientcommand '"+Command+"'")
            if 'bl' in Flags and _AllowUnload:
                es.flags('remove', 'cheat', Command)
                Log(3, "Removed cheat-flag from command '"+Command+"'")

    if CFGVar('protectvars') == 1:
        for ServerVar in ProtectServerVars:
            es.flags('remove', 'notify', ServerVar)
            if _AllowUnload and ProtectServerVars[ServerVar].has_key('cheatflag') and ProtectServerVars[ServerVar].has_key('unload_remove_cheatflag') and ProtectServerVars[ServerVar].has_key('cheatflag') and ProtectServerVars[ServerVar].has_key('unload_remove_cheatflag'):
                es.flags('remove', 'cheat', ServerVar)
                Log(3, "Removed cheat-flag from variable '" + ServerVar + "'")

    gamethread.cancelDelayed('servsecurity_varmonitor')
    gamethread.cancelDelayed('servsecurity_crashreporter')
    gamethread.cancelDelayed('servsecurity_writelogfile')
    gamethread.cancelDelayed('servsecurity_resetconnectionattempsvar')

    if CFGVar('crashreporter'):
        tmpfile = es.getAddonPath('servsecurity') + "/data/tmpcrashreport.txt"
        fp = open(tmpfile, 'w')
        fp.write(str(0))
        fp.close()


    es.addons.unregisterSayFilter(sayFilter)
    es.addons.unregisterClientCommandFilter(cmdFilter)

    if not _AllowUnload:
        Log(1, "Unauthorized unload! Reload...")
        es.server.queuecmd("es_xload servsecurity")
        gamethread.delayed(0.1, es.server.queuecmd, ("es_xload servsecurity"))
        gamethread.delayed(0.5, es.server.queuecmd, ("es_xload servsecurity"))
    else:
        Loaded = False

    CloseLogFile()


def OpenLogfile():
    global LogfilePointer

    if CFGVar('logtype') in [2,3]:
        if not CFGVar('one_logfile'):
            now = datetime.datetime.now()
            if CFGVar('timeformat') == 1:
                FileName = now.strftime("%m-%d-%Y")
            elif CFGVar('timeformat') == 3:
                FileName = now.strftime("%Y-%m-%d")
            else:
                FileName = now.strftime("%d.%m.%Y")

            LogFile = es.getAddonPath('servsecurity') + "/logs/ServSecurity_Log_" + str(FileName) + ".txt"
        else:
            LogFile = es.getAddonPath('servsecurity') + "/logs/ServSecurity_Log.txt"

        if not os.path.isfile(LogFile):
            fp = open(LogFile, 'w')
            fp.writelines("")
            fp.close()

        LogfilePointer = open(LogFile, 'a')


def Timestamp2Date(timestamp):
    date = datetime.datetime.fromtimestamp(float(timestamp))
    if CFGVar('timeformat') == 1:
        return str(date.strftime("%m/%d/%Y %H:%I:%S"))
    elif CFGVar('timeformat') == 3:
        return str(date.strftime("%Y-%m-%d %H:%I:%S"))
    else:
        return str(date.strftime("%d.%m.%Y %H:%I:%S"))


def CheckPlugins():
    if not Loaded:
        print('ServSecurity not loaded')
        return
    Log(1, "Get plugin-list...")
    threading.Thread(target=GetPluginList, args=()).start()


def GetPluginList():
    socket.setdefaulttimeout(5)

    try:
        Result = urllib.urlopen(PluginVerUL).read()
    except:
        Log(1, "Plugin-Check failed")
        return

    Split1 = Result.split("*|*")
    for PluginAndVersion in Split1:
        Split2 = PluginAndVersion.split("||")
        PluginVar = Split2[0]
        PluginVer = Split2[1]

        if Plugins.has_key(PluginVar) and es.exists('variable', PluginVar):
            Vars = PluginVer.split("|")
            UpToDate = False
            for var in Vars:
                if es.ServerVar(PluginVar) == var:
                    UpToDate = True
                    break

            if not UpToDate:
                if "|" in PluginVer:
                    PluginVer = "versions are '" + "', '".join(PluginVer.split("|"))+"'"
                else:
                    PluginVer = "version is '" + PluginVer + "'"
                Log(1, "Your '" + Plugins[PluginVar]['pluginname'] + "' is out of date! Current " + PluginVer + ", you use '" + es.ServerVar(PluginVar) + "' - Download-Homepage: " + Plugins[PluginVar]['homepage'])

    Log(1, "Plugin-Check finished")


def CloseLogFile():
    global LogfilePointer
    if LogfilePointer:
        LogfilePointer.close()
        LogfilePointer = None

def XCopy():
    if es.getargc() != 3:
        es.dbgmsg(0, 'Syntax: es_xcopy <varname> <varname2>')
        return
    Var1 = str(es.getargv(1))
    Var2 = str(es.getargv(2))

    if ProtectServerVars.has_key(Var1.lower()) or ProtectServerVars.has_key(Var2.lower()):
        Log(1, "Blocked es_xcopy %s %s" % (Var1, Var2))
        return

    if not es.exists('variable', Var2):
        es.dbgmsg(0, 'The var "'+Var2+'" could not be found')
        return
    if not es.exists('variable', Var1):
        es.dbgmsg(0, 'The var "'+Var1+'" could not be found')
        return

    es.set(Var1, es.ServerVar(Var2))

def Copy():
    if es.getargc() < 3:
        es.dbgmsg(0, 'Syntax: es_copy <varname> <varname2>')
        return

    Args = es.getargs().replace(";", "")

    es.server.cmd("es es_xcopy %s" % Args)

def WriteCrashReportFile():
    gamethread.cancelDelayed('servsecurity_crashreporter')
    gamethread.delayedname(2, 'servsecurity_crashreporter', WriteCrashReportFile)

    try:
        tmpfile = es.getAddonPath('servsecurity') + "/data/tmpcrashreport.txt"
        fp = open(tmpfile, 'w')
        fp.write(str(time.time()))
        fp.close()
    except:
        Log(2, "Cant write to " + str(tmpfile))
        return


def LogFileWrite():
    gamethread.cancelDelayed('servsecurity_writelogfile')
    gamethread.delayedname(4, 'servsecurity_writelogfile', LogFileWrite)
    CloseLogFile()
    OpenLogfile()


def UnloadMe():
    global _AllowUnload
    if not Loaded:
        print('ServSecurity not loaded')
        return

    ArgPass = es.getargv(1)
    if _Password == ArgPass:
        _AllowUnload = True
        es.server.queuecmd("es_unload servsecurity")
    else:
        Log(1, "Invalid ServSecurity password! Unload failed!")


def SetServSecurityPassword(): # ServSecurity 0.3
    ArgPass = es.getargv(1)
    SetPasswd(ArgPass)


def SetPassword():
    ArgPass = es.getargv(1)
    SetPasswd(ArgPass)


def SetPasswd(ArgPass):
    global _Password
    if Loaded or not PreLoad:
        Log(1, "ServSecurity already loaded! Cant set password")
        return

    if _Password == "":
        if len(ArgPass) < 6:
            Log(1, "Cant set ServSecurity password: Password is too short")
        else:
            _Password = ArgPass
            Log(1, "ServSecurity password set")
    else:
        Log(1, "Cant set ServSecurity password: Password already set")


def player_disconnect(ev):
    if IllegalCharCount.has_key(int(ev['userid'])):
        del IllegalCharCount[int(ev['userid'])]
    if int(ev['userid']) in UserIDToIP:
        del UserIDToIP[int(ev['userid'])]


def Void():
    return


def round_start(ev):
    global Kicked
    DisableRCONCrashExploit()
    Kicked = []


def Check4Updates():
    if not Loaded:
        return

    Log(1, "Checking for updates...")
    threading.Thread(target=UpdateCheckThread, args=()).start()


def es_map_start(ev):
    Check4Updates()
    CheckPlugins()


def player_activate(ev):
    if CFGVar('steamid_pending_kick') and ev['es_steamid'].lower() == "steam_id_pending":
        gamethread.delayed(CFGVar('steamid_pending_kick_time'), CheckPlayerSteamID, (ev['userid']))
    if CFGVar('messsage_on_connect'):
        es.tell(ev['userid'], "#multi", "#default Server protected by#lightgreen ServSecurity 0.5#default developed by#green Dark Session")


def CheckPlayerSteamID(userid):
    if not es.exists('userid', userid):
        return

    steamid = es.getplayersteamid(userid)
    if steamid.lower() == "steam_id_pending":
        Username = es.getplayername(userid)
        Kick(userid, "Your Steam-ID is still pending, please try again")
        Log(3, "Player '" + Username + "' was kicked because his Steam-ID wasn't validated")


def UpdateCheckThread():
    socket.setdefaulttimeout(5)

    try:
        Result = urllib.urlopen(UpdateCheckURL).read()
    except:
        Log(1, "Update-Check failed")
        return
    if float(Result) > ScriptVersion:
        Log(1, "ServSecurity Version '%s' avaiable! Visit http://addons.eventscripts.com/addons/view/servsecurity" % float(Result))
    else:
        Log(1, "ServSecurity up-to-date")


def ResetConnectionAttempsVar():
    global ConnectionAttemps
    gamethread.cancelDelayed('servsecurity_resetconnectionattempsvar')
    gamethread.delayedname(30, 'servsecurity_resetconnectionattempsvar', ResetConnectionAttempsVar)
    if len(ConnectionAttemps):
        ConnectionAttemps = {}
        Log(3, "Connection attemps resetted")


def bannedservercmd():
    Log(1, "Blocked: Command")
    return


def player_team(ev):
    if not es.exists('userid', ev['userid']):
        return


    if not int(ev['team']) in range(1,4):
        Playername = es.getplayername(ev['userid'])
        Log(1, "Kicked player '" + str(Playername) + "' for using the unassigned exploit")
        Kick(ev['userid'], "Detected: Unassigned exploit")


def DisableRCONCrashExploit():
    es.forcevalue('sv_rcon_minfailures', 99999999)
    es.forcevalue('sv_rcon_maxfailures', 99999999)
    es.forcevalue('sv_rcon_minfailuretime', 1)
    Log(3, "RCON Crash Exploit disabled")


def sayFilter(userid, text, teamonly):

    if not CFGVar('block_text_with_illegal_chars'):
        return (userid, text, teamonly)

    if not es.exists('userid', userid) and int(userid) != -1: # userid -1 = Console
        Log(2, "Blocked text from non-exists userid '%s'" % userid)
        if int(userid) in UserIDToIP and not UserIDToIP[int(userid)].lower() in IPWhitelist:
            Kick(userid, "No chance!", UserIDToIP[int(userid)])
        return (0,0,0)

    userid = int(userid)

    if not CheckCharacters(text):
        if not IllegalCharCount.has_key(userid):
            IllegalCharCount[userid] = 0
        IllegalCharCount[userid] += 1
        Playername = es.getplayername(userid)
        if IllegalCharCount[userid] >= CFGVar('illegal_chars_max_tries'):
            ip = es.createplayerlist(userid)[userid]['address'].split(":")[0]
            Kick(userid, "Kicked and banned for using illegal chars in your messages!", ip)
            Steamid = es.getplayersteamid(userid)
            es.server.queuecmd("banid %s %s" % (CFGVar('steamidbantime'), Steamid))
            Log(1, "Player '" + str(Playername) + "' kicked and banned for using illegal characters in his messages")
        else:
            Log(2, "Blocked text from '%s' (userid '%s') which contains illegal chars" % (Playername,userid))
        return (0,0,0)

    return (userid, text, teamonly)


def cmdFilter(userid, args):
    if not es.exists('userid', userid) and int(userid) != -1: # userid -1 = Console
        Log(2, "Blocked command '%s' from non-exists userid '%s'" % (args[0], userid))
        if not args[0].lower() in ConnectingBlockNotBanCMDs and int(userid) in UserIDToIP and not UserIDToIP[int(userid)].lower() in IPWhitelist:
            Kick(userid, "You cant send commands while connecting", UserIDToIP[int(userid)])
        return False

    if CFGVar('kick_unassigned') and args[0].lower() == "close":
        if not int(es.getplayerteam(userid)) in range(1,3):
            Playername = es.getplayername(userid)
            Log(1, "Kicked player '"+str(Playername)+"' for using the unassigned exploit")
            Kick(userid, "Detected: Unassigned exploit")

    return True


def Log(level, text):
    if level > CFGVar('loglevel'):
        return

    Lev = "unknow"
    level = int(level)

    if level == 1:
        Lev = "Important  "
    elif level == 2:
        Lev = "Warning    "
    elif level == 3:
        Lev = "Information"

    LogText = "[ServSecurity " + Timestamp2Date(time.time()) + "] [%s] %s" % (Lev, text)

    if CFGVar('logtype') in [1,3]:
        es.log(LogText)
    if CFGVar('logtype') in [2,3]:
        if LogfilePointer:
            LogfilePointer.writelines(LogText + Wrap)
        elif CFGVar('logtype') == 2:
            es.log(LogText)


def CFGVar(name):
    if Config.has_key(name):
        return int(Config[name])


def player_connect(ev):
    IP = ev["address"].split(":")[0]
    UserIDToIP[int(ev['userid'])] = IP
    if ev["networkid"] in ConnectWhitelist or IP in IPWhitelist:
        Log(2, "Player '%s' with ip '%s' is in whitelist" % (ev["name"], IP))
        return

    if CFGVar('block_connection_spam'):
        if not IP in ConnectionAttemps:
            ConnectionAttemps[IP] = 0

        ConnectionAttemps[IP] += 1
        Log(3, "Player '%s' connected with ip '%s' (attemp number %s)" % (ev["name"], IP, ConnectionAttemps[IP]))

        if CFGVar('maxconnectionsperip') <= ConnectionAttemps[IP]:
            Kick(ev["userid"], "Too many connection attemps", IP)
            Log(2, "Player '" + str(ev["name"]) + "' kicked for too many connection attemps")
            return

    if not CheckUsername(ev["userid"], ev["name"], IP):
        return


def player_changename(ev):
    if not es.exists('userid', ev['userid']):
        return

    userid = int(ev['userid'])
    username = ev["newname"]
    steamid = ev["es_steamid"]

    ip = es.createplayerlist(userid)[userid]['address'].split(":")[0]
    if not CheckUsername(userid, username, ip):
        es.server.queuecmd("banid %s %s" % (CFGVar('steamidbantime'), steamid))
        Log(2, "Added steam id '%s' to banlist for '%s' minutes" % (steamid, CFGVar('ipbantime')))


def CheckUsername(userid, username, ip):
    if not CFGVar('block_colored_names'):
        return True

    if len(username) > MaxUsernameLength:
        Kick(userid, "Your username is too long!", ip)
        Log(2, "Player '%s...' kicked for using a too long username" % username[0:MaxUsernameLength])
        return False
    if len(username.replace(" ", "")) <= 1:
        Kick(userid, "Your username is too short!")
        Log(2, "Player '%s' kicked for using a too short username" % username)
        return False
    elif not CheckCharacters(username):
        Kick(userid, "Your username contains illegal characters", ip)
        Log(2, "Player '%s' kicked for using illegal characters" % username)
        return False
    elif username in ForbiddenUsernames:
        Kick(userid, "Use a REAL name")
        Log(2, "Player '%s' kicked for using a forbidden username" % username)
        return False
    return True


def CheckCharacters(string):

    for ForbiddenChar in ForbiddenChars:
        if ForbiddenChar in string:
            return False

    if '\x00' in string:
        return False
    return True


def VariableMonitoring():
    gamethread.delayedname(2, 'servsecurity_varmonitor', VariableMonitoring)
    for ServerVar in ProtectServerVars:
        Value = str(es.ServerVar(ServerVar))
        if Value != ProtectServerVars[ServerVar]['default']:
            if ProtectServerVars[ServerVar].has_key('ignoreempty') and ProtectServerVars[ServerVar]['ignoreempty'] and Value == "":
                continue

            es.forcevalue(ServerVar, ProtectServerVars[ServerVar]['default'])
            Default = str(ProtectServerVars[ServerVar]['default'])
            if ProtectServerVars[ServerVar].has_key('hidevalue') and ProtectServerVars[ServerVar]['hidevalue']:
                Default = "(***PROTECTED***)"

            LogLevel = 2
            if ProtectServerVars[ServerVar].has_key('loglevel'):
                LogLevel = ProtectServerVars[ServerVar]['loglevel']
            Log(LogLevel, "Variable '" + str(ServerVar) + "' was changed to '" + Value + "', forced back to '" +  Default + "'")


def server_cvar(ev):
    if not Loaded:
        return
    var = ev["cvarname"]
    if ProtectServerVars.has_key(var):
        value = str(es.ServerVar(var))
        if ProtectServerVars[var]['default'] != value:
            es.forcevalue(var, ProtectServerVars[var]['default'])
            Default = str(ProtectServerVars[var]['default'])
            if ProtectServerVars[var].has_key('hidevalue') and ProtectServerVars[var]['hidevalue']:
                Default = "(***PROTECTED***)"
            Log(2, "Variable '" + str(var) + "' was changed to '" + value + "', forced back to '" +  Default + "'")


def Kick(userid, reason, ip = False):
    userid = int(userid)
    if userid in Kicked:
        return
    es.server.insertcmd("kickid %s [ServSecurity] %s" % (userid, reason))
    if ip:
        es.server.queuecmd("addip %i %s" % (CFGVar('ipbantime'), ip))
        Log(3, "IP '%s' banned for '%s' minutes" % (ip, CFGVar('ipbantime')))

    Kicked.append(userid)


#################### EOF ########################